<?php
/**
 * Copyright (c) 2014 ScientiaMobile, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * Refer to the COPYING.txt file distributed with this package.
 *
 *
 * @category   WURFL
 * @package	WURFL
 * @copyright  ScientiaMobile, Inc.
 * @license	GNU Affero General Public License
 * @version	$id$
 */
/**
 * Handles the chain of WURFL_Handlers_Handler objects
 * @package	WURFL
 * @see WURFL_Handlers_Handler
 */
class WURFL_UserAgentHandlerChain {
	 
	/**
	 * @var array of WURFL_Handlers_Handler objects
	 */
	private $_userAgentHandlers = array();
	
	/**
	 * Adds a WURFL_Handlers_Handler to the chain
	 *
	 * @param WURFL_Handlers_Handler $handler
	 * @return WURFL_UserAgentHandlerChain $this
	 */
	public function addUserAgentHandler(WURFL_Handlers_Handler $handler) {
		$size = count($this->_userAgentHandlers); 
		if ($size > 0) {
			$this->_userAgentHandlers[$size-1]->setNextHandler($handler);
		}
		$this->_userAgentHandlers[] = $handler;
		return $this;
	}
	
	/**
	 * @return array An array of all the WURFL_Handlers_Handler objects
	 */
	public function getHandlers() {
		return $this->_userAgentHandlers;
	}
	
	/**
	 * Adds the pair $userAgent, $deviceID to the clusters they belong to.
	 *
	 * @param String $userAgent
	 * @param String $deviceID
	 * @see WURFL_Handlers_Handler::filter()
	 */
	public function filter($userAgent, $deviceID) {
		WURFL_Handlers_Utils::reset();
		$this->_userAgentHandlers[0]->filter($userAgent, $deviceID);
	}
	
	
	
	/**
	 * Return the the device id for the request 
	 *
	 * @param WURFL_Request_GenericRequest $request
	 * @return String deviceID
	 */
	public function match(WURFL_Request_GenericRequest $request) {
		WURFL_Handlers_Utils::reset();
		return $this->_userAgentHandlers[0]->match($request);
	}
	
	/**
	 * Save the data from each WURFL_Handlers_Handler
	 * @see WURFL_Handlers_Handler::persistData()
	 */
	public function persistData() {
		foreach ($this->_userAgentHandlers as $userAgentHandler) {
			$userAgentHandler->persistData();
		}
		
	}
	
	/**
	 * Collect data
	 * @return array data
	 */
	public function collectData() {
		$userAgentsWithDeviceId = array();		
		foreach ($this->_userAgentHandlers as $userAgentHandler) {
			/**
			 * @see WURFL_Handlers_Handler::getUserAgentsWithDeviceId()
			 */
			$current = $userAgentHandler->getUserAgentsWithDeviceId();
			if(!empty($current)) {
				$userAgentsWithDeviceId = array_merge($userAgentsWithDeviceId, $current);
			} 
		}
		return $userAgentsWithDeviceId;
	}	
}